<?php
$title = 'Participantes - WOW LIVE';
ob_start();
?>

<div class="row">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Participantes</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-users me-2 text-primary"></i>Gerenciar Participantes
                <?php if ($evento_selecionado): ?>
                    <small class="text-muted">- <?= htmlspecialchars($evento_selecionado->nome) ?></small>
                <?php endif; ?>
            </h1>
            <div class="btn-group">
                <a href="/participantes/cadastrar<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-success">
                    <i class="fas fa-user-plus me-2"></i>Novo Participante
                </a>
                <a href="/participantes/importar<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-info">
                    <i class="fas fa-file-excel me-2"></i>Importar Excel
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Mensagens de feedback -->
<?php if (!empty($success)): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i>
    <?= $success ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (!empty($error)): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <?= $error ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="/participantes" class="row g-3">
                    <div class="col-md-4">
                        <label for="evento_id" class="form-label">Filtrar por Evento</label>
                        <select class="form-select" id="evento_id" name="evento_id">
                            <option value="">Todos os eventos</option>
                            <?php foreach ($eventos as $evento): ?>
                            <option value="<?= $evento['id'] ?>" <?= $evento_id == $evento['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($evento['nome']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="search" class="form-label">Buscar</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?= htmlspecialchars($_GET['search'] ?? '') ?>" 
                               placeholder="Nome, email ou código de inscrição">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i>Filtrar
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Lista de participantes -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>Lista de Participantes
                    <span class="badge bg-primary ms-2"><?= count($participantes) ?></span>
                </h5>
                <?php if (!empty($participantes)): ?>
                <div class="btn-group btn-group-sm">
                    <button type="button" class="btn btn-outline-success" onclick="exportarCSV()">
                        <i class="fas fa-file-csv me-1"></i>CSV
                    </button>
                    <button type="button" class="btn btn-outline-primary" onclick="exportarExcel()">
                        <i class="fas fa-file-excel me-1"></i>Excel
                    </button>
                </div>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <?php if (!empty($participantes)): ?>
                <div class="table-responsive">
                    <table class="table table-hover" id="participantesTable">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Nome Completo</th>
                                <th>Email</th>
                                <th>Telefone</th>
                                <th>Cargo</th>
                                <th>Data Cadastro</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($participantes as $participante): ?>
                            <tr>
                                <td>
                                    <span class="badge bg-secondary"><?= htmlspecialchars($participante['codigo_inscricao']) ?></span>
                                </td>
                                <td>
                                    <div>
                                        <strong><?= htmlspecialchars($participante['nome_completo']) ?></strong>
                                        <?php if (!empty($participante['nome_credencial']) && $participante['nome_credencial'] != $participante['nome_completo']): ?>
                                        <br><small class="text-muted">Crachá: <?= htmlspecialchars($participante['nome_credencial']) ?></small>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td><?= htmlspecialchars($participante['email']) ?></td>
                                <td><?= htmlspecialchars($participante['telefone']) ?></td>
                                <td><?= htmlspecialchars($participante['cargo']) ?></td>
                                <td><?= date('d/m/Y H:i', strtotime($participante['data_cadastro'])) ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="/participantes/editar?id=<?= $participante['id'] ?>" class="btn btn-outline-warning" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-outline-danger" title="Excluir" 
                                                onclick="confirmarExclusao(<?= $participante['id'] ?>, '<?= htmlspecialchars($participante['nome_completo']) ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-info" title="Gerar Etiqueta" 
                                                onclick="gerarEtiqueta(<?= $participante['id'] ?>)">
                                            <i class="fas fa-tag"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Nenhum participante encontrado</h5>
                    <p class="text-muted">
                        <?php if ($evento_id): ?>
                            Não há participantes cadastrados neste evento.
                        <?php else: ?>
                            Não há participantes cadastrados. Selecione um evento ou cadastre novos participantes.
                        <?php endif; ?>
                    </p>
                    <div class="mt-3">
                        <a href="/participantes/cadastrar<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-success me-2">
                            <i class="fas fa-user-plus me-2"></i>Cadastrar Participante
                        </a>
                        <a href="/participantes/importar<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-info">
                            <i class="fas fa-file-excel me-2"></i>Importar Excel
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="confirmarExclusaoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Confirmar Exclusão
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir o participante <strong id="nomeParticipanteExcluir"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-warning me-2"></i>
                    <strong>Atenção:</strong> Esta ação não pode ser desfeita.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <a href="#" id="linkExcluir" class="btn btn-danger">
                    <i class="fas fa-trash me-2"></i>Excluir Participante
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmarExclusao(id, nome) {
    document.getElementById('nomeParticipanteExcluir').textContent = nome;
    document.getElementById('linkExcluir').href = '/participantes/excluir?id=' + id;
    new bootstrap.Modal(document.getElementById('confirmarExclusaoModal')).show();
}

function gerarEtiqueta(id) {
    window.open('/etiquetas/gerar?participante_id=' + id, '_blank');
}

function exportarCSV() {
    // Implementar exportação CSV
    alert('Funcionalidade de exportação CSV será implementada em breve.');
}

function exportarExcel() {
    // Implementar exportação Excel
    alert('Funcionalidade de exportação Excel será implementada em breve.');
}
</script>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

