<?php
$title = ($this->participant->id ? 'Editar' : 'Cadastrar') . ' Participante - WOW LIVE';
ob_start();
?>

<div class="row">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/participantes">Participantes</a></li>
                <li class="breadcrumb-item active"><?= $this->participant->id ? 'Editar' : 'Cadastrar' ?></li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-user-plus me-2 text-primary"></i><?= $this->participant->id ? 'Editar' : 'Cadastrar' ?> Participante
            </h1>
            <a href="/participantes<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Voltar
            </a>
        </div>
    </div>
</div>

<!-- Mensagens de feedback -->
<?php if (!empty($error)): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <?= $error ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>Dados do Participante
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="/participantes/<?= $this->participant->id ? 'editar' : 'cadastrar' ?>" class="needs-validation" novalidate>
                    <?php if ($this->participant->id): ?>
                    <input type="hidden" name="id" value="<?= $this->participant->id ?>">
                    <?php endif; ?>
                    <input type="hidden" name="evento_id" value="<?= $evento_id ?? $this->participant->evento_id ?? '' ?>">

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="evento_select" class="form-label">Evento *</label>
                            <select class="form-select" id="evento_select" name="evento_id" required <?= $this->participant->id ? 'disabled' : '' ?>>
                                <option value="">Selecione um evento</option>
                                <?php foreach ($eventos as $evento): ?>
                                <option value="<?= $evento["id"] ?>" 
                                    <?= ($evento_id == $evento["id"] || ($this->participant->id && $this->participant->evento_id == $evento["id"])) ? "selected" : "" ?>>
                                    <?= htmlspecialchars($evento["nome"]) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">Por favor, selecione um evento.</div>
                        </div>
                        <div class="col-md-6">
                            <label for="codigo_inscricao" class="form-label">Código de Inscrição</label>
                            <input type="text" class="form-control" id="codigo_inscricao" name="codigo_inscricao" 
                                   value="<?= htmlspecialchars($this->participant->codigo_inscricao ?? $next_code ?? '') ?>" 
                                   placeholder="Gerado automaticamente se vazio">
                            <div class="form-text">Ex: WL0001. Deixe vazio para gerar automaticamente.</div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="nome_completo" class="form-label">Nome Completo *</label>
                            <input type="text" class="form-control" id="nome_completo" name="nome_completo" 
                                   value="<?= htmlspecialchars($this->participant->nome_completo ?? '') ?>" required>
                            <div class="invalid-feedback">Por favor, informe o nome completo.</div>
                        </div>
                        <div class="col-md-6">
                            <label for="nome_credencial" class="form-label">Nome para Crachá</label>
                            <input type="text" class="form-control" id="nome_credencial" name="nome_credencial" 
                                   value="<?= htmlspecialchars($this->participant->nome_credencial ?? '') ?>">
                            <div class="form-text">Nome que aparecerá na etiqueta (opcional).</div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="email" class="form-label">Email *</label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   value="<?= htmlspecialchars($this->participant->email ?? '') ?>" required>
                            <div class="invalid-feedback">Por favor, informe um email válido.</div>
                        </div>
                        <div class="col-md-6">
                            <label for="telefone" class="form-label">Telefone</label>
                            <input type="text" class="form-control" id="telefone" name="telefone" 
                                   value="<?= htmlspecialchars($this->participant->telefone ?? '') ?>" placeholder="(XX) XXXXX-XXXX">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="cpf" class="form-label">CPF</label>
                            <input type="text" class="form-control" id="cpf" name="cpf" 
                                   value="<?= htmlspecialchars($this->participant->cpf ?? '') ?>" placeholder="XXX.XXX.XXX-XX">
                        </div>
                        <div class="col-md-4">
                            <label for="rg" class="form-label">RG</label>
                            <input type="text" class="form-control" id="rg" name="rg" 
                                   value="<?= htmlspecialchars($this->participant->rg ?? '') ?>">
                        </div>
                        <div class="col-md-4">
                            <label for="genero" class="form-label">Gênero</label>
                            <select class="form-select" id="genero" name="genero">
                                <option value="">Selecione</option>
                                <option value="Masculino" <?= ($this->participant->genero ?? '') == 'Masculino' ? 'selected' : '' ?>>Masculino</option>
                                <option value="Feminino" <?= ($this->participant->genero ?? '') == 'Feminino' ? 'selected' : '' ?>>Feminino</option>
                                <option value="Outro" <?= ($this->participant->genero ?? '') == 'Outro' ? 'selected' : '' ?>>Outro</option>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="data_nascimento" class="form-label">Data de Nascimento</label>
                            <input type="date" class="form-control" id="data_nascimento" name="data_nascimento" 
                                   value="<?= htmlspecialchars($this->participant->data_nascimento ?? '') ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="cargo" class="form-label">Cargo</label>
                            <input type="text" class="form-control" id="cargo" name="cargo" 
                                   value="<?= htmlspecialchars($this->participant->cargo ?? '') ?>">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="cep" class="form-label">CEP</label>
                            <input type="text" class="form-control" id="cep" name="cep" 
                                   value="<?= htmlspecialchars($this->participant->cep ?? '') ?>" placeholder="XXXXX-XXX">
                        </div>
                        <div class="col-md-4">
                            <label for="estado" class="form-label">Estado</label>
                            <input type="text" class="form-control" id="estado" name="estado" 
                                   value="<?= htmlspecialchars($this->participant->estado ?? '') ?>">
                        </div>
                        <div class="col-md-4">
                            <label for="cidade" class="form-label">Cidade</label>
                            <input type="text" class="form-control" id="cidade" name="cidade" 
                                   value="<?= htmlspecialchars($this->participant->cidade ?? '') ?>">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="bairro" class="form-label">Bairro</label>
                            <input type="text" class="form-control" id="bairro" name="bairro" 
                                   value="<?= htmlspecialchars($this->participant->bairro ?? '') ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="endereco" class="form-label">Endereço</label>
                            <input type="text" class="form-control" id="endereco" name="endereco" 
                                   value="<?= htmlspecialchars($this->participant->endereco ?? '') ?>">
                        </div>
                    </div>

                    <div class="d-flex gap-2 mt-4">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save me-2"></i><?= $this->participant->id ? 'Salvar Alterações' : 'Cadastrar Participante' ?>
                        </button>
                        <a href="/participantes<?= $evento_id ? '?evento_id=' . $evento_id : '' ?>" class="btn btn-outline-secondary btn-lg">
                            <i class="fas fa-times me-2"></i>Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if ($this->participant->id): ?>
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>Informações Adicionais
                </h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <small class="text-muted">ID do Participante</small>
                    <div class="fw-bold">#<?= $this->participant->id ?></div>
                </div>
                <div class="mb-3">
                    <small class="text-muted">Evento</small>
                    <div class="fw-bold">
                        <?php 
                            $event_info = new Event($this->db);
                            $event_info->findById($this->participant->evento_id);
                            echo htmlspecialchars($event_info->nome);
                        ?>
                    </div>
                </div>
                <div class="mb-3">
                    <small class="text-muted">Data de Cadastro</small>
                    <div class="fw-bold"><?= date("d/m/Y H:i", strtotime($this->participant->data_cadastro)) ?></div>
                </div>
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-outline-danger" onclick="confirmarExclusao(<?= $this->participant->id ?>, '<?= htmlspecialchars($this->participant->nome_completo) ?>')">
                        <i class="fas fa-trash me-2"></i>Excluir Participante
                    </button>
                    <button type="button" class="btn btn-outline-primary" onclick="gerarEtiqueta(<?= $this->participant->id ?>)">
                        <i class="fas fa-tag me-2"></i>Gerar Etiqueta
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Modal de confirmação de exclusão (reutilizado do index) -->
<div class="modal fade" id="confirmarExclusaoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Confirmar Exclusão
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir o participante <strong id="nomeParticipanteExcluir"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-warning me-2"></i>
                    <strong>Atenção:</strong> Esta ação não pode ser desfeita.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <a href="#" id="linkExcluir" class="btn btn-danger">
                    <i class="fas fa-trash me-2"></i>Excluir Participante
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmarExclusao(id, nome) {
    document.getElementById("nomeParticipanteExcluir").textContent = nome;
    document.getElementById("linkExcluir").href = "/participantes/excluir?id=" + id;
    new bootstrap.Modal(document.getElementById("confirmarExclusaoModal")).show();
}

function gerarEtiqueta(id) {
    window.open("/etiquetas/gerar?participante_id=" + id, "_blank");
}
</script>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

