<?php
$title = 'Eventos - WOW LIVE';
ob_start();
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-calendar me-2 text-primary"></i>Gerenciar Eventos
            </h1>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#novoEventoModal">
                <i class="fas fa-plus me-2"></i>Novo Evento
            </button>
        </div>
    </div>
</div>

<!-- Mensagens de feedback -->
<?php if (!empty($success)): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i>
    <?= htmlspecialchars($success) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (!empty($error)): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <?= htmlspecialchars($error) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Lista de eventos -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>Lista de Eventos
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($eventos)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nome do Evento</th>
                                <th>Data de Criação</th>
                                <th>Participantes</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($eventos as $evento): ?>
                            <tr>
                                <td>
                                    <span class="badge bg-secondary">#<?= $evento['id'] ?></span>
                                </td>
                                <td>
                                    <strong><?= htmlspecialchars($evento['nome']) ?></strong>
                                </td>
                                <td>
                                    <?= date('d/m/Y H:i', strtotime($evento['data_criacao'])) ?>
                                </td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?= $evento['total_participantes'] ?> participantes
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="/participantes?evento_id=<?= $evento['id'] ?>" class="btn btn-sm btn-outline-info" title="Ver Participantes">
                                            <i class="fas fa-users"></i>
                                        </a>
                                        <a href="/eventos/editar?id=<?= $evento['id'] ?>" class="btn btn-sm btn-outline-warning" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" title="Excluir" onclick="confirmarExclusao(<?= $evento['id'] ?>, '<?= htmlspecialchars($evento['nome']) ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-calendar fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Nenhum evento cadastrado</h5>
                    <p class="text-muted">Clique no botão "Novo Evento" para criar seu primeiro evento.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal para novo evento -->
<div class="modal fade" id="novoEventoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Novo Evento
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="/eventos">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome do Evento *</label>
                        <input type="text" class="form-control" id="nome" name="nome" required maxlength="255" placeholder="Digite o nome do evento">
                        <div class="form-text">Este nome será usado para identificar o evento no sistema.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Criar Evento
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="confirmarExclusaoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Confirmar Exclusão
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir o evento <strong id="nomeEventoExcluir"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-warning me-2"></i>
                    <strong>Atenção:</strong> Esta ação também excluirá todos os participantes e configurações relacionadas a este evento. Esta ação não pode ser desfeita.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <a href="#" id="linkExcluir" class="btn btn-danger">
                    <i class="fas fa-trash me-2"></i>Excluir Evento
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmarExclusao(id, nome) {
    document.getElementById('nomeEventoExcluir').textContent = nome;
    document.getElementById('linkExcluir').href = '/eventos/excluir?id=' + id;
    new bootstrap.Modal(document.getElementById('confirmarExclusaoModal')).show();
}
</script>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

