<?php
$title = 'Editar Evento - WOW LIVE';
ob_start();
?>

<div class="row">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/eventos">Eventos</a></li>
                <li class="breadcrumb-item active">Editar Evento</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-edit me-2 text-primary"></i>Editar Evento
            </h1>
            <a href="/eventos" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Voltar
            </a>
        </div>
    </div>
</div>

<!-- Mensagens de erro -->
<?php if (!empty($error)): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <?= htmlspecialchars($error) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Formulário de edição -->
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-calendar me-2"></i>Informações do Evento
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="/eventos/editar">
                    <input type="hidden" name="id" value="<?= $this->event->id ?>">
                    
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome do Evento *</label>
                        <input type="text" class="form-control form-control-lg" id="nome" name="nome" 
                               value="<?= htmlspecialchars($this->event->nome) ?>" required maxlength="255">
                        <div class="form-text">Este nome será usado para identificar o evento no sistema.</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Data de Criação</label>
                        <input type="text" class="form-control" 
                               value="<?= date('d/m/Y H:i:s', strtotime($this->event->data_criacao)) ?>" readonly>
                        <div class="form-text">Data em que o evento foi criado no sistema.</div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Salvar Alterações
                        </button>
                        <a href="/eventos" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <!-- Informações adicionais -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>Informações
                </h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <small class="text-muted">ID do Evento</small>
                    <div class="fw-bold">#<?= $this->event->id ?></div>
                </div>

                <div class="mb-3">
                    <small class="text-muted">Total de Participantes</small>
                    <div class="fw-bold">
                        <span class="badge bg-primary fs-6">
                            <?= $this->event->getParticipantsCount() ?> participantes
                        </span>
                    </div>
                </div>

                <div class="mb-3">
                    <small class="text-muted">Data de Criação</small>
                    <div class="fw-bold"><?= date('d/m/Y H:i', strtotime($this->event->data_criacao)) ?></div>
                </div>
            </div>
        </div>

        <!-- Ações rápidas -->
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>Ações Rápidas
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="/participantes?evento_id=<?= $this->event->id ?>" class="btn btn-outline-info">
                        <i class="fas fa-users me-2"></i>Ver Participantes
                    </a>
                    <a href="/participantes/cadastrar?evento_id=<?= $this->event->id ?>" class="btn btn-outline-success">
                        <i class="fas fa-user-plus me-2"></i>Cadastrar Participante
                    </a>
                    <a href="/participantes/importar?evento_id=<?= $this->event->id ?>" class="btn btn-outline-warning">
                        <i class="fas fa-file-excel me-2"></i>Importar Excel
                    </a>
                    <a href="/etiquetas/gerar?evento_id=<?= $this->event->id ?>" class="btn btn-outline-primary">
                        <i class="fas fa-tags me-2"></i>Gerar Etiquetas
                    </a>
                </div>
            </div>
        </div>

        <!-- Zona de perigo -->
        <div class="card mt-3 border-danger">
            <div class="card-header bg-danger text-white">
                <h5 class="card-title mb-0">
                    <i class="fas fa-exclamation-triangle me-2"></i>Zona de Perigo
                </h5>
            </div>
            <div class="card-body">
                <p class="card-text text-muted">
                    Excluir este evento removerá permanentemente todos os dados relacionados, incluindo participantes e configurações.
                </p>
                <button type="button" class="btn btn-outline-danger w-100" onclick="confirmarExclusao()">
                    <i class="fas fa-trash me-2"></i>Excluir Evento
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="confirmarExclusaoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Confirmar Exclusão
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir o evento <strong><?= htmlspecialchars($this->event->nome) ?></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-warning me-2"></i>
                    <strong>Atenção:</strong> Esta ação também excluirá todos os <?= $this->event->getParticipantsCount() ?> participantes e configurações relacionadas a este evento. Esta ação não pode ser desfeita.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <a href="/eventos/excluir?id=<?= $this->event->id ?>" class="btn btn-danger">
                    <i class="fas fa-trash me-2"></i>Excluir Evento
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmarExclusao() {
    new bootstrap.Modal(document.getElementById('confirmarExclusaoModal')).show();
}
</script>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

