<?php
$title = 'Dashboard - WOW LIVE';
ob_start();
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-home me-2 text-primary"></i>Dashboard
            </h1>
            <span class="text-muted">Bem-vindo, <?= $_SESSION['nome'] ?>!</span>
        </div>
    </div>
</div>

<!-- Cards de estatísticas -->
<div class="row mb-4">
    <div class="col-md-6 col-lg-3 mb-3">
        <div class="card bg-primary text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-1">Total de Eventos</h5>
                        <h2 class="mb-0"><?= $totalEventos ?></h2>
                    </div>
                    <div class="text-white-50">
                        <i class="fas fa-calendar fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-lg-3 mb-3">
        <div class="card bg-success text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-1">Total de Participantes</h5>
                        <h2 class="mb-0"><?= $totalParticipantes ?></h2>
                    </div>
                    <div class="text-white-50">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-lg-3 mb-3">
        <div class="card bg-info text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-1">Etiquetas Geradas</h5>
                        <h2 class="mb-0">0</h2>
                    </div>
                    <div class="text-white-50">
                        <i class="fas fa-tags fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-lg-3 mb-3">
        <div class="card bg-warning text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-1">Importações</h5>
                        <h2 class="mb-0">0</h2>
                    </div>
                    <div class="text-white-50">
                        <i class="fas fa-file-excel fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ações rápidas -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>Ações Rápidas
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <a href="/eventos" class="btn btn-outline-primary w-100 h-100 d-flex flex-column justify-content-center align-items-center py-3">
                            <i class="fas fa-calendar fa-2x mb-2"></i>
                            <span>Gerenciar Eventos</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="/participantes/cadastrar" class="btn btn-outline-success w-100 h-100 d-flex flex-column justify-content-center align-items-center py-3">
                            <i class="fas fa-user-plus fa-2x mb-2"></i>
                            <span>Cadastrar Participante</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="/participantes/importar" class="btn btn-outline-info w-100 h-100 d-flex flex-column justify-content-center align-items-center py-3">
                            <i class="fas fa-file-excel fa-2x mb-2"></i>
                            <span>Importar Excel</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="/etiquetas/gerar" class="btn btn-outline-warning w-100 h-100 d-flex flex-column justify-content-center align-items-center py-3">
                            <i class="fas fa-tags fa-2x mb-2"></i>
                            <span>Gerar Etiquetas</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Lista de eventos recentes -->
<?php if (!empty($eventos)): ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-calendar me-2"></i>Eventos Recentes
                </h5>
                <a href="/eventos" class="btn btn-sm btn-outline-primary">Ver Todos</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Nome do Evento</th>
                                <th>Data de Criação</th>
                                <th>Participantes</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($eventos, 0, 5) as $evento): ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($evento['nome']) ?></strong>
                                </td>
                                <td>
                                    <?= date('d/m/Y H:i', strtotime($evento['data_criacao'])) ?>
                                </td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php 
                                        $this->event->id = $evento['id'];
                                        echo $this->event->getParticipantsCount();
                                        ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="/participantes?evento_id=<?= $evento['id'] ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-users me-1"></i>Ver Participantes
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-calendar fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum evento cadastrado</h5>
                <p class="text-muted">Comece criando seu primeiro evento para gerenciar participantes e gerar etiquetas.</p>
                <a href="/eventos" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Criar Primeiro Evento
                </a>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

