<?php
$title = 'Login - WOW LIVE';
ob_start();
?>

<div class="min-vh-100 d-flex align-items-center justify-content-center bg-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-5">
                        <!-- Logo -->
                        <div class="text-center mb-4">
                            <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                <i class="fas fa-tags text-white fa-2x"></i>
                            </div>
                            <h2 class="mt-3 mb-1 fw-bold text-primary">WOW LIVE</h2>
                            <p class="text-muted">Gerador de Etiquetas</p>
                        </div>

                        <!-- Mensagem de erro -->
                        <?php if (!empty($error)): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <?= htmlspecialchars($error) ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php endif; ?>

                        <!-- Formulário de login -->
                        <form method="POST" action="/login">
                            <div class="mb-3">
                                <label for="username" class="form-label">
                                    <i class="fas fa-user me-1"></i>Usuário
                                </label>
                                <input type="text" class="form-control form-control-lg" id="username" name="username" required autofocus>
                            </div>

                            <div class="mb-4">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-1"></i>Senha
                                </label>
                                <input type="password" class="form-control form-control-lg" id="password" name="password" required>
                            </div>

                            <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                <i class="fas fa-sign-in-alt me-2"></i>Entrar
                            </button>
                        </form>

                        <!-- Informações de acesso -->
                        <div class="text-center">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Acesso restrito a administradores
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Credenciais de teste -->
                <div class="card mt-3 border-info">
                    <div class="card-body text-center">
                        <h6 class="card-title text-info">
                            <i class="fas fa-key me-1"></i>Credenciais de Teste
                        </h6>
                        <p class="card-text mb-1">
                            <strong>Usuário:</strong> admin
                        </p>
                        <p class="card-text">
                            <strong>Senha:</strong> admin123
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include '../src/Views/layouts/main.php';
?>

