<?php

namespace WowLive\Models;

class Participant {
    private $conn;
    private $table_name = "participantes";

    public $id;
    public $evento_id;
    public $codigo_inscricao;
    public $nome_completo;
    public $nome_credencial;
    public $rg;
    public $cpf;
    public $genero;
    public $data_nascimento;
    public $estado;
    public $cidade;
    public $cep;
    public $bairro;
    public $endereco;
    public $cargo;
    public $telefone;
    public $email;
    public $data_cadastro;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  (evento_id, codigo_inscricao, nome_completo, nome_credencial, rg, cpf, genero, 
                   data_nascimento, estado, cidade, cep, bairro, endereco, cargo, telefone, email) 
                  VALUES 
                  (:evento_id, :codigo_inscricao, :nome_completo, :nome_credencial, :rg, :cpf, :genero, 
                   :data_nascimento, :estado, :cidade, :cep, :bairro, :endereco, :cargo, :telefone, :email)";
        
        $stmt = $this->conn->prepare($query);
        
        // Bind dos parâmetros
        $stmt->bindParam(':evento_id', $this->evento_id);
        $stmt->bindParam(':codigo_inscricao', $this->codigo_inscricao);
        $stmt->bindParam(':nome_completo', $this->nome_completo);
        $stmt->bindParam(':nome_credencial', $this->nome_credencial);
        $stmt->bindParam(':rg', $this->rg);
        $stmt->bindParam(':cpf', $this->cpf);
        $stmt->bindParam(':genero', $this->genero);
        $stmt->bindParam(':data_nascimento', $this->data_nascimento);
        $stmt->bindParam(':estado', $this->estado);
        $stmt->bindParam(':cidade', $this->cidade);
        $stmt->bindParam(':cep', $this->cep);
        $stmt->bindParam(':bairro', $this->bairro);
        $stmt->bindParam(':endereco', $this->endereco);
        $stmt->bindParam(':cargo', $this->cargo);
        $stmt->bindParam(':telefone', $this->telefone);
        $stmt->bindParam(':email', $this->email);

        if ($stmt->execute()) {
            $this->id = $this->conn->lastInsertId();
            return true;
        }
        
        return false;
    }

    public function read($evento_id = null) {
        $query = "SELECT * FROM " . $this->table_name;
        
        if ($evento_id) {
            $query .= " WHERE evento_id = :evento_id";
        }
        
        $query .= " ORDER BY data_cadastro DESC";
        
        $stmt = $this->conn->prepare($query);
        
        if ($evento_id) {
            $stmt->bindParam(':evento_id', $evento_id);
        }
        
        $stmt->execute();
        return $stmt;
    }

    public function findById($id) {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = :id LIMIT 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch();
            $this->id = $row['id'];
            $this->evento_id = $row['evento_id'];
            $this->codigo_inscricao = $row['codigo_inscricao'];
            $this->nome_completo = $row['nome_completo'];
            $this->nome_credencial = $row['nome_credencial'];
            $this->rg = $row['rg'];
            $this->cpf = $row['cpf'];
            $this->genero = $row['genero'];
            $this->data_nascimento = $row['data_nascimento'];
            $this->estado = $row['estado'];
            $this->cidade = $row['cidade'];
            $this->cep = $row['cep'];
            $this->bairro = $row['bairro'];
            $this->endereco = $row['endereco'];
            $this->cargo = $row['cargo'];
            $this->telefone = $row['telefone'];
            $this->email = $row['email'];
            $this->data_cadastro = $row['data_cadastro'];
            return true;
        }
        
        return false;
    }

    public function generateNextCode($evento_id) {
        $query = "SELECT COUNT(*) as total FROM " . $this->table_name . " WHERE evento_id = :evento_id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':evento_id', $evento_id);
        $stmt->execute();

        $row = $stmt->fetch();
        $next_number = $row['total'] + 1;
        
        return 'WL' . str_pad($next_number, 4, '0', STR_PAD_LEFT);
    }

    public function codeExists($codigo, $evento_id, $exclude_id = null) {
        $query = "SELECT id FROM " . $this->table_name . " WHERE codigo_inscricao = :codigo AND evento_id = :evento_id";
        
        if ($exclude_id) {
            $query .= " AND id != :exclude_id";
        }
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':codigo', $codigo);
        $stmt->bindParam(':evento_id', $evento_id);
        
        if ($exclude_id) {
            $stmt->bindParam(':exclude_id', $exclude_id);
        }
        
        $stmt->execute();
        
        return $stmt->rowCount() > 0;
    }

    public function emailExists($email, $evento_id, $exclude_id = null) {
        $query = "SELECT id FROM " . $this->table_name . " WHERE email = :email AND evento_id = :evento_id";
        
        if ($exclude_id) {
            $query .= " AND id != :exclude_id";
        }
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':evento_id', $evento_id);
        
        if ($exclude_id) {
            $stmt->bindParam(':exclude_id', $exclude_id);
        }
        
        $stmt->execute();
        
        return $stmt->rowCount() > 0;
    }
}

