<?php

namespace WowLive\Models;

class Event {
    private $conn;
    private $table_name = "eventos";

    public $id;
    public $nome;
    public $data_criacao;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " (nome) VALUES (:nome)";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nome', $this->nome);

        if ($stmt->execute()) {
            $this->id = $this->conn->lastInsertId();
            $this->createDefaultFields();
            return true;
        }
        
        return false;
    }

    public function read() {
        $query = "SELECT id, nome, data_criacao FROM " . $this->table_name . " ORDER BY data_criacao DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        return $stmt;
    }

    public function findById($id) {
        $query = "SELECT id, nome, data_criacao FROM " . $this->table_name . " WHERE id = :id LIMIT 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch();
            $this->id = $row['id'];
            $this->nome = $row['nome'];
            $this->data_criacao = $row['data_criacao'];
            return true;
        }
        
        return false;
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . " SET nome = :nome WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nome', $this->nome);
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }

    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }

    public function getParticipantsCount() {
        $query = "SELECT COUNT(*) as total FROM participantes WHERE evento_id = :evento_id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':evento_id', $this->id);
        $stmt->execute();

        $row = $stmt->fetch();
        return $row['total'];
    }

    private function createDefaultFields() {
        $defaultFields = [
            ['campo_nome' => 'codigo_inscricao', 'visivel' => true, 'obrigatorio' => true, 'ordem' => 1],
            ['campo_nome' => 'nome_completo', 'visivel' => true, 'obrigatorio' => true, 'ordem' => 2],
            ['campo_nome' => 'nome_credencial', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 3],
            ['campo_nome' => 'rg', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 4],
            ['campo_nome' => 'cpf', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 5],
            ['campo_nome' => 'genero', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 6],
            ['campo_nome' => 'data_nascimento', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 7],
            ['campo_nome' => 'estado', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 8],
            ['campo_nome' => 'cidade', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 9],
            ['campo_nome' => 'cep', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 10],
            ['campo_nome' => 'bairro', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 11],
            ['campo_nome' => 'endereco', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 12],
            ['campo_nome' => 'cargo', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 13],
            ['campo_nome' => 'telefone', 'visivel' => true, 'obrigatorio' => false, 'ordem' => 14],
            ['campo_nome' => 'email', 'visivel' => true, 'obrigatorio' => true, 'ordem' => 15]
        ];

        $query = "INSERT INTO campos_configuraveis (evento_id, campo_nome, visivel, obrigatorio, ordem) VALUES (:evento_id, :campo_nome, :visivel, :obrigatorio, :ordem)";
        $stmt = $this->conn->prepare($query);

        foreach ($defaultFields as $field) {
            $stmt->bindParam(':evento_id', $this->id);
            $stmt->bindParam(':campo_nome', $field['campo_nome']);
            $stmt->bindParam(':visivel', $field['visivel']);
            $stmt->bindParam(':obrigatorio', $field['obrigatorio']);
            $stmt->bindParam(':ordem', $field['ordem']);
            $stmt->execute();
        }
    }
}

