<?php

namespace WowLive\Controllers;

use WowLive\Models\Event;

class EventController {
    private $db;
    private $event;

    public function __construct($db) {
        $this->db = $db;
        $this->event = new Event($db);
    }

    public function dashboard() {
        // Buscar estatísticas gerais
        $stmt = $this->event->read();
        $eventos = $stmt->fetchAll();

        $totalEventos = count($eventos);
        $totalParticipantes = 0;

        foreach ($eventos as $evento) {
            $this->event->id = $evento['id'];
            $totalParticipantes += $this->event->getParticipantsCount();
        }

        include '../src/Views/dashboard.php';
    }

    public function index() {
        $stmt = $this->event->read();
        $eventos = $stmt->fetchAll();

        // Adicionar contagem de participantes para cada evento
        foreach ($eventos as &$evento) {
            $this->event->id = $evento['id'];
            $evento['total_participantes'] = $this->event->getParticipantsCount();
        }

        $success = $_SESSION['success'] ?? '';
        $error = $_SESSION['error'] ?? '';
        unset($_SESSION['success'], $_SESSION['error']);

        include '../src/Views/events/index.php';
    }

    public function create() {
        $nome = trim($_POST['nome'] ?? '');

        if (empty($nome)) {
            $_SESSION['error'] = 'O nome do evento é obrigatório.';
            header('Location: /eventos');
            exit();
        }

        $this->event->nome = $nome;

        if ($this->event->create()) {
            $_SESSION['success'] = 'Evento criado com sucesso!';
        } else {
            $_SESSION['error'] = 'Erro ao criar evento.';
        }

        header('Location: /eventos');
        exit();
    }

    public function edit() {
        $id = $_GET['id'] ?? 0;

        if (!$this->event->findById($id)) {
            $_SESSION['error'] = 'Evento não encontrado.';
            header('Location: /eventos');
            exit();
        }

        $error = $_SESSION['error'] ?? '';
        unset($_SESSION['error']);

        include '../src/Views/events/edit.php';
    }

    public function update() {
        $id = $_POST['id'] ?? 0;
        $nome = trim($_POST['nome'] ?? '');

        if (empty($nome)) {
            $_SESSION['error'] = 'O nome do evento é obrigatório.';
            header('Location: /eventos/editar?id=' . $id);
            exit();
        }

        if (!$this->event->findById($id)) {
            $_SESSION['error'] = 'Evento não encontrado.';
            header('Location: /eventos');
            exit();
        }

        $this->event->nome = $nome;

        if ($this->event->update()) {
            $_SESSION['success'] = 'Evento atualizado com sucesso!';
        } else {
            $_SESSION['error'] = 'Erro ao atualizar evento.';
        }

        header('Location: /eventos');
        exit();
    }

    public function delete() {
        $id = $_GET['id'] ?? 0;

        if (!$this->event->findById($id)) {
            $_SESSION['error'] = 'Evento não encontrado.';
            header('Location: /eventos');
            exit();
        }

        if ($this->event->delete()) {
            $_SESSION['success'] = 'Evento excluído com sucesso!';
        } else {
            $_SESSION['error'] = 'Erro ao excluir evento.';
        }

        header('Location: /eventos');
        exit();
    }
}

