<?php
session_start();
error_reporting(E_ALL); 
ini_set("display_errors", 1);
require_once '../vendor/autoload.php';

use WowLive\Config\Database;
use WowLive\Controllers\AuthController;
use WowLive\Controllers\EventController;
use WowLive\Controllers\ParticipantController;
use WowLive\Controllers\LabelController;

// Configuração de roteamento simples
$request = $_SERVER['REQUEST_URI'];
$path = parse_url($request, PHP_URL_PATH);
$path = str_replace('/public', '', $path);

// Instanciar controladores
$database = new Database();
$db = $database->getConnection();

$authController = new AuthController($db);
$eventController = new EventController($db);
$participantController = new ParticipantController($db);
$labelController = new LabelController($db);

// Roteamento
switch ($path) {
    case '/':
    case '/login':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $authController->login();
        } else {
            $authController->showLogin();
        }
        break;
    
    case '/logout':
        $authController->logout();
        break;
    
    case '/dashboard':
        $authController->requireAuth();
        $eventController->dashboard();
        break;
    
    case '/eventos':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $eventController->create();
        } else {
            $eventController->index();
        }
        break;
    
    case '/eventos/editar':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $eventController->update();
        }
        else {
            $eventController->edit();
        }
        break;
    
    case '/eventos/excluir':
        $authController->requireAuth();
        $eventController->delete();
        break;
    
    case '/participantes':
        $authController->requireAuth();
        $participantController->index();
        break;
    
    case '/participantes/cadastrar':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $participantController->create();
        } else {
            $participantController->showForm();
        }
        break;
    
    case '/participantes/importar':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $participantController->import();
        } else {
            $participantController->showImport();
        }
        break;
    
    case '/participantes/editar':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $participantController->update();
        } else {
            $participantController->edit();
        }
        break;

    case '/participantes/excluir':
        $authController->requireAuth();
        $participantController->delete();
        break;

    case '/etiquetas':
        $authController->requireAuth();
        $labelController->index();
        break;
    
    case '/etiquetas/gerar':
        $authController->requireAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $labelController->generate();
        } else {
            $labelController->showForm();
        }
        break;
    
    default:
        http_response_code(404);
        echo "Página não encontrada";
        break;
}


