-- Criação do banco de dados WOW LIVE Etiquetas
CREATE DATABASE IF NOT EXISTS wow_live_etiquetas CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE wow_live_etiquetas;

-- Tabela de eventos
CREATE TABLE eventos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(255) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de campos configuráveis
CREATE TABLE campos_configuraveis (
    id INT AUTO_INCREMENT PRIMARY KEY,
    evento_id INT NOT NULL,
    campo_nome VARCHAR(100) NOT NULL,
    visivel BOOLEAN DEFAULT TRUE,
    obrigatorio BOOLEAN DEFAULT FALSE,
    ordem INT DEFAULT 0,
    FOREIGN KEY (evento_id) REFERENCES eventos(id) ON DELETE CASCADE
);

-- Tabela de participantes
CREATE TABLE participantes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    evento_id INT NOT NULL,
    codigo_inscricao VARCHAR(50),
    nome_completo VARCHAR(255),
    nome_credencial VARCHAR(255),
    rg VARCHAR(20),
    cpf VARCHAR(14),
    genero VARCHAR(20),
    data_nascimento DATE,
    estado VARCHAR(50),
    cidade VARCHAR(100),
    cep VARCHAR(10),
    bairro VARCHAR(100),
    endereco VARCHAR(255),
    cargo VARCHAR(100),
    telefone VARCHAR(20),
    email VARCHAR(255),
    data_cadastro DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (evento_id) REFERENCES eventos(id) ON DELETE CASCADE
);

-- Tabela de usuários administrativos
CREATE TABLE usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    nome VARCHAR(255) NOT NULL,
    email VARCHAR(255),
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Inserir usuário administrativo padrão (senha: admin123)
INSERT INTO usuarios (username, password, nome, email) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrador', 'admin@wowlive.com');

-- Inserir evento de exemplo
INSERT INTO eventos (nome) VALUES ('Evento de Teste WOW LIVE');

-- Inserir campos configuráveis padrão para o evento de exemplo
INSERT INTO campos_configuraveis (evento_id, campo_nome, visivel, obrigatorio, ordem) VALUES
(1, 'codigo_inscricao', TRUE, TRUE, 1),
(1, 'nome_completo', TRUE, TRUE, 2),
(1, 'nome_credencial', TRUE, FALSE, 3),
(1, 'rg', TRUE, FALSE, 4),
(1, 'cpf', TRUE, FALSE, 5),
(1, 'genero', TRUE, FALSE, 6),
(1, 'data_nascimento', TRUE, FALSE, 7),
(1, 'estado', TRUE, FALSE, 8),
(1, 'cidade', TRUE, FALSE, 9),
(1, 'cep', TRUE, FALSE, 10),
(1, 'bairro', TRUE, FALSE, 11),
(1, 'endereco', TRUE, FALSE, 12),
(1, 'cargo', TRUE, FALSE, 13),
(1, 'telefone', TRUE, FALSE, 14),
(1, 'email', TRUE, TRUE, 15);

-- Inserir alguns participantes de exemplo
INSERT INTO participantes (evento_id, codigo_inscricao, nome_completo, nome_credencial, email, telefone, cargo) VALUES
(1, 'WL001', 'João Silva Santos', 'João Silva', 'joao@email.com', '(11) 99999-9999', 'Desenvolvedor'),
(1, 'WL002', 'Maria Oliveira Costa', 'Maria Oliveira', 'maria@email.com', '(11) 88888-8888', 'Designer'),
(1, 'WL003', 'Pedro Souza Lima', 'Pedro Souza', 'pedro@email.com', '(11) 77777-7777', 'Gerente de Projeto');

